<?php
require_once __DIR__.'/../bootstrap.php'; Auth::requireAdmin();
$pdo = Database::pdo();
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['id'], $_POST['status'])) {
  $pdo->prepare("UPDATE orders SET status=? WHERE id=?")->execute([$_POST['status'], (int)$_POST['id']]);
  header('Location: /admin/orders.php'); exit;
}
$rows = $pdo->query("SELECT * FROM orders ORDER BY id DESC")->fetchAll();
$itemsStmt = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi JOIN products p ON p.id=oi.product_id WHERE order_id=?");
?><!doctype html><html lang="fa" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="/assets/main.css"><title>سفارش‌ها</title></head><body class="container">
<div class="header"><a class="btn" href="/admin/dashboard.php">داشبورد</a></div>
<?php foreach($rows as $o): ?>
  <div class="card">
    <h3>سفارش #<?= (int)$o['id']?> — کد: <?= Util::e($o['order_code'])?> — وضعیت: <span class="badge"><?= Util::e($o['status'])?></span></h3>
    <p>نام: <?= Util::e($o['name'])?> | موبایل: <?= Util::e($o['mobile'])?> | ایمیل: <?= Util::e($o['email'])?></p>
    <p>آدرس: <?= nl2br(Util::e($o['address']))?></p>
    <p>مبلغ: <?= number_format((int)$o['amount'])?></p>
    <?php $itemsStmt->execute([(int)$o['id']]); $its=$itemsStmt->fetchAll(); ?>
    <table class="table"><tr><th>محصول</th><th>تعداد</th><th>قیمت</th></tr>
    <?php foreach($its as $it): ?><tr><td><?= Util::e($it['name'])?></td><td><?= (int)$it['qty']?></td><td><?= number_format((int)$it['price'])?></td></tr><?php endforeach; ?>
    </table>
    <form method="post" style="margin-top:8px">
      <input type="hidden" name="id" value="<?= (int)$o['id']?>">
      <select class="input" name="status">
        <?php foreach(['pending','processing','paid','failed','canceled'] as $st): ?>
          <option <?= $st===$o['status']?'selected':''?>><?= $st ?></option>
        <?php endforeach; ?>
      </select>
      <button class="btn">بروزرسانی وضعیت</button>
    </form>
  </div>
<?php endforeach; ?>
</body></html>
