<?php
declare(strict_types=1);
session_start();
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Tehran');

require_once __DIR__ . '/config/config.php'; // created by installer

spl_autoload_register(function($class){
  $map = [
    'Database' => __DIR__.'/lib/Database.php',
    'Auth'     => __DIR__.'/lib/Auth.php',
    'Cart'     => __DIR__.'/lib/Cart.php',
    'Zibal'    => __DIR__.'/lib/Zibal.php',
    'Mailer'   => __DIR__.'/lib/Mailer.php',
    'Seo'      => __DIR__.'/lib/Seo.php',
    'Util'     => __DIR__.'/lib/Util.php',
  ];
  if(isset($map[$class])) require_once $map[$class];
});

if (!defined('BASE_URL')) { die('App not installed. Run install.php'); }
