<?php
ini_set('display_errors','1');
error_reporting(E_ALL);
header('Content-Type: text/html; charset=UTF-8');
if (file_exists(__DIR__.'/config/config.php') && filesize(__DIR__.'/config/config.php')>0) { die('قبلاً نصب شده است.'); }
$error = ''; $ok = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $db_host = trim($_POST['db_host']??'localhost');
  $db_name = trim($_POST['db_name']??'');
  $db_user = trim($_POST['db_user']??'');
  $db_pass = trim($_POST['db_pass']??'');
  $admin_email = trim($_POST['admin_email']??'');
  $admin_pass  = $_POST['admin_pass']??'';
  $store_name  = trim($_POST['store_name']??'فروشگاه');
  $base_url    = rtrim(trim($_POST['base_url']??''),'/');
  $zibal_merchant = trim($_POST['zibal_merchant']??'');

  try {
    $pdo = new PDO("mysql:host=$db_host;charset=utf8mb4",$db_user,$db_pass,[PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci");
    $pdo->exec("USE `$db_name`");
    $schema = file_get_contents(__DIR__.'/sql/schema.sql');
    $pdo->exec($schema);

    $stmt = $pdo->prepare('INSERT INTO admins (email,password_hash,name) VALUES (?,?,?)');
    $stmt->execute([$admin_email, password_hash($admin_pass, PASSWORD_BCRYPT), 'مدیر']);

    if (!is_dir(__DIR__.'/config')) mkdir(__DIR__.'/config',0775,true);
    $cfg = "<?php
ini_set('display_errors','1');
error_reporting(E_ALL);
header('Content-Type: text/html; charset=UTF-8');\n".
      "define('DB_HOST','{$db_host}');\n".
      "define('DB_NAME','{$db_name}');\n".
      "define('DB_USER','{$db_user}');\n".
      "define('DB_PASS','".str_replace(\"'\", \"\\\\'\", $db_pass)."');\n".
      "define('BASE_URL','{$base_url}');\n".
      "define('STORE_NAME','{$store_name}');\n".
      "define('ZIBAL_MERCHANT','{$zibal_merchant}');\n".
      "define('SMTP_HOST','');\n".
      "define('SMTP_USER','');\n".
      "define('SMTP_PASS','');\n".
      "define('SMTP_PORT',587);\n";
    file_put_contents(__DIR__.'/config/config.php',$cfg);
    $ok = 'نصب با موفقیت انجام شد. فایل config ساخته شد.';
  } catch(Exception $e) {
    $error = $e->getMessage();
  }
}
?>
<!doctype html><html lang="fa" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>نصب فروشگاه</title>
<link rel="stylesheet" href="https://unpkg.com/modern-css-reset/dist/reset.min.css">
<style>
body{font-family:Tahoma, sans-serif;background:#f6f7fb;color:#222}
.container{max-width:720px;margin:40px auto;background:#fff;border-radius:14px;box-shadow:0 6px 24px rgba(0,0,0,.06);padding:24px}
.row{display:grid;grid-template-columns:1fr 1fr;gap:12px}
input,button{padding:12px;border:1px solid #ddd;border-radius:10px}
button{background:#111;color:#fff;cursor:pointer}
.alert{padding:10px;border-radius:10px;margin-bottom:10px}
.alert.ok{background:#e6ffec;border:1px solid #a6f3ba}
.alert.err{background:#ffecec;border:1px solid #f3a6a6}
</style></head><body><div class="container">
  <h2>نصب فروشگاه</h2>
  <?php
ini_set('display_errors','1');
error_reporting(E_ALL);
header('Content-Type: text/html; charset=UTF-8'); if($ok): ?><div class="alert ok"><?=htmlspecialchars($ok)?></div><?php
ini_set('display_errors','1');
error_reporting(E_ALL);
header('Content-Type: text/html; charset=UTF-8'); endif; ?>
  <?php
ini_set('display_errors','1');
error_reporting(E_ALL);
header('Content-Type: text/html; charset=UTF-8'); if($error): ?><div class="alert err"><?=htmlspecialchars($error)?></div><?php
ini_set('display_errors','1');
error_reporting(E_ALL);
header('Content-Type: text/html; charset=UTF-8'); endif; ?>
  <form method="post">
    <h3>تنظیمات دیتابیس</h3>
    <div class="row">
      <div><label>DB Host</label><input name="db_host" required value="localhost"></div>
      <div><label>DB Name</label><input name="db_name" required></div>
      <div><label>DB User</label><input name="db_user" required></div>
      <div><label>DB Pass</label><input type="password" name="db_pass"></div>
    </div>
    <h3>ادمین</h3>
    <div class="row">
      <div><label>Admin Email</label><input type="email" name="admin_email" required></div>
      <div><label>Admin Pass</label><input type="password" name="admin_pass" required></div>
    </div>
    <h3>فروشگاه</h3>
    <div class="row">
      <div><label>Store Name</label><input name="store_name" value="فروشگاه"></div>
      <div><label>Base URL</label><input name="base_url" placeholder="https://example.com" required></div>
      <div><label>Zibal Merchant</label><input name="zibal_merchant" required></div>
    </div>
    <p><button type="submit">نصب</button></p>
    <p>پس از نصب: پوشه <code>public/theme</code> را با فایل‌های قالب‌تان پر کنید.</p>
  </form>
</div></body></html>
