<?php
final class Auth {
  public static function login(string $email, string $password): bool {
    $stmt = Database::pdo()->prepare('SELECT * FROM admins WHERE email=? LIMIT 1');
    $stmt->execute([$email]);
    $admin = $stmt->fetch();
    if ($admin && password_verify($password, $admin['password_hash'])) {
      $_SESSION['admin_id']=$admin['id'];
      $_SESSION['admin_email']=$admin['email'];
      return true;
    }
    return false;
  }
  public static function requireAdmin(): void {
    if (empty($_SESSION['admin_id'])) {
      header('Location: '.BASE_URL.'/admin/index.php'); exit;
    }
  }
  public static function logout(): void { session_destroy(); }
}
