<?php
final class Cart {
  private static function &bag(): array {
    if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];
    return $_SESSION['cart'];
  }
  public static function add(int $productId, int $qty=1): array {
    $cart =& self::bag();
    $cart[$productId] = ($cart[$productId] ?? 0) + max(1,$qty);
    return $cart;
  }
  public static function set(int $productId, int $qty): array {
    $cart =& self::bag();
    if ($qty<=0) unset($cart[$productId]); else $cart[$productId]=$qty;
    return $cart;
  }
  public static function clear(): void { $_SESSION['cart']=[]; }
  public static function items(): array {
    $cart = self::bag();
    if (!$cart) return [];
    $ids = implode(',', array_map('intval', array_keys($cart)));
    $q = Database::pdo()->query("SELECT id,name,slug,price,image FROM products WHERE id IN ($ids) AND is_active=1");
    $rows = $q->fetchAll();
    foreach ($rows as &$r) { $r['qty']=$cart[$r['id']]; $r['total']=$r['qty']*$r['price']; }
    return $rows;
  }
  public static function total(): int {
    return array_sum(array_column(self::items(),'total'));
  }
}
