<?php
final class Seo {
  public static function head(string $title, string $description='', string $canonical=''): string {
    $titleFull = $title.' | '.STORE_NAME;
    $desc = htmlspecialchars($description ?: $titleFull, ENT_QUOTES,'UTF-8');
    $can  = $canonical ?: (BASE_URL.$_SERVER['REQUEST_URI']);
    return <<<HTML
<title>{$titleFull}</title>
<meta name="description" content="{$desc}">
<link rel="canonical" href="{$can}">
<meta property="og:title" content="{$titleFull}">
<meta property="og:description" content="{$desc}">
<meta property="og:url" content="{$can}">
<meta property="og:type" content="website">
<meta name="twitter:card" content="summary">
HTML;
  }
}
