<?php
final class Util {
  public static function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES,'UTF-8'); }
  public static function jsonOut($data): void {
    header('Content-Type: application/json; charset=UTF-8'); echo json_encode($data, JSON_UNESCAPED_UNICODE); exit;
  }
  public static function csrfToken(): string {
    if (empty($_SESSION['csrf'])) $_SESSION['csrf']=bin2hex(random_bytes(16));
    return $_SESSION['csrf'];
  }
  public static function csrfCheck(string $t): void {
    if (empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'],$t)) { http_response_code(403); exit('CSRF'); }
  }
  public static function orderCode(): string { return strtoupper(bin2hex(random_bytes(6))); }
}
