<?php
require_once __DIR__ . '/../bootstrap.php';
$pdo = Database::pdo();
$route = $_GET['route'] ?? '';
$parts = array_values(array_filter(explode('/', trim($route,'/'))));
$slug = $parts[1] ?? null;

function render($view, $vars=[]){ extract($vars); include __DIR__."/theme/header.php"; include __DIR__."/theme/{$view}.php"; include __DIR__."/theme/footer.php"; }

$path = $parts[0] ?? 'home';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  // cart add/set + checkout submit
  if ($path==='cart' && ($parts[1]??'')==='add') {
    $id = (int)($_POST['product_id']??0);
    if ($id>0) Cart::add($id,1);
    header('Location: /cart'); exit;
  }
  if ($path==='checkout' && ($parts[1]??'')==='submit') {
    $items = Cart::items();
    if (!$items) { header('Location:/cart'); exit; }
    $total = Cart::total();
    $code = Util::orderCode();
    $stmt = $pdo->prepare("INSERT INTO orders (order_code,name,email,mobile,address,lat,lng,amount,status) VALUES (?,?,?,?,?,?,?,?, 'pending')");
    $stmt->execute([$code, $_POST['name']??'', $_POST['email']??'', $_POST['mobile']??'', $_POST['address']??'', $_POST['lat']?:null, $_POST['lng']?:null, $total]);
    $orderId = (int)$pdo->lastInsertId();
    $ins = $pdo->prepare("INSERT INTO order_items (order_id,product_id,qty,price) VALUES (?,?,?,?)");
    foreach ($items as $it) { $ins->execute([$orderId, $it['id'], $it['qty'], $it['price']]); }
    // Request payment via Zibal
    $z = new Zibal(ZIBAL_MERCHANT, BASE_URL.'/payment/callback');
    $resp = $z->requestPayment($total, $code, $_POST['mobile']??null, 'پرداخت سفارش ' . $code);
    $trackId = $resp['trackId'];
    $pdo->prepare("INSERT INTO payments (order_id,gateway,track_id,result_code,raw_response) VALUES (?,?,?,?,?)")
        ->execute([$orderId,'zibal',$trackId,(int)($resp['result']??0), json_encode($resp,JSON_UNESCAPED_UNICODE)]);
    Cart::clear();
    header('Location: '.Zibal::paymentStartUrl($trackId)); exit;
  }
}

switch ($path) {
  case 'product':
    $stmt=$pdo->prepare('SELECT * FROM products WHERE slug=? AND is_active=1 LIMIT 1'); $stmt->execute([$slug]); $p=$stmt->fetch();
    if(!$p){ http_response_code(404); echo "404"; exit; }
    $head = Seo::head($p['name'], $p['short_desc'], BASE_URL.'/product/'.$p['slug']);
    render('product', compact('p','head')); break;

  case 'cart':
    $items = Cart::items(); $total = Cart::total();
    $head = Seo::head('سبد خرید');
    render('cart', compact('items','total','head')); break;

  case 'checkout':
    if (!Cart::items()) { header('Location:/cart'); exit; }
    $head = Seo::head('فرم اطلاعات');
    render('checkout', compact('head')); break;

  case 'payment':
    // /payment/callback?trackId=...
    if (($parts[1]??'') === 'callback') {
      $track = $_GET['trackId'] ?? '';
      if (!$track) { $message='شناسه تراکنش یافت نشد.'; render('payment_result', compact('message')); break; }
      $z = new Zibal(ZIBAL_MERCHANT, BASE_URL.'/payment/callback');
      $verify = $z->verify($track);
      // Find payment & order
      $stmt = $pdo->prepare("SELECT p.*, o.id as oid FROM payments p JOIN orders o ON o.id=p.order_id WHERE p.track_id=? LIMIT 1");
      $stmt->execute([$track]); $pay = $stmt->fetch();
      if (!$pay) { $message='سفارش یافت نشد.'; render('payment_result', compact('message')); break; }
      $status = (int)($verify['result']??-1);
      if ($status==100) { // success
        $pdo->prepare("UPDATE orders SET status='paid' WHERE id=?")->execute([(int)$pay['order_id']]);
        $pdo->prepare("UPDATE payments SET result_code=?, ref_number=?, raw_response=?, verified_at=NOW() WHERE id=?")
            ->execute([$status, isset($verify['refNumber']) ? $verify['refNumber'] : '', json_encode($verify,JSON_UNESCAPED_UNICODE), (int)$pay['id']]);
        $message = 'پرداخت موفق بود. کد سفارش: '.$pay['order_id'];
      } else {
        $pdo->prepare("UPDATE orders SET status='failed' WHERE id=?")->execute([(int)$pay['order_id']]);
        $pdo->prepare("UPDATE payments SET result_code=?, raw_response=?, verified_at=NOW() WHERE id=?")
            ->execute([$status, json_encode($verify,JSON_UNESCAPED_UNICODE), (int)$pay['id']]);
        $message = 'پرداخت ناموفق بود. کد: '.$status;
      }
      // notify admin
      Mailer::notifyAdmin('سفارش جدید', '<p>وضعیت: '.Util::e($message).'</p>');
      render('payment_result', compact('message')); break;
    }
    http_response_code(404); echo '404'; break;

  case 'sitemap.xml':
  case 'sitemap':
    header('Content-Type: application/xml; charset=UTF-8');
    $rows = $pdo->query("SELECT slug FROM products WHERE is_active=1")->fetchAll();
    echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
    echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
    echo '<url><loc>'.BASE_URL.'</loc></url>';
    foreach($rows as $r){ echo '<url><loc>'.BASE_URL.'/product/'.htmlspecialchars($r['slug']).'</loc></url>'; }
    echo '</urlset>';
    break;

  case 'robots.txt':
  case 'robots':
    header('Content-Type: text/plain; charset=UTF-8');
    echo "User-agent: *\nAllow: /\nSitemap: ".BASE_URL."/sitemap\n";
    break;

  default:
    $head = Seo::head('خانه');
    render('home', compact('head'));
}
