<div class="card"><h2>فرم اطلاعات و آدرس</h2></div>
<form class="card" method="post" action="/checkout/submit">
  <div style="display:grid;grid-template-columns:1fr 1fr;gap:12px">
    <div><label>نام و نام خانوادگی</label><input class="input" name="name" required></div>
    <div><label>موبایل</label><input class="input" name="mobile" required></div>
    <div><label>ایمیل</label><input class="input" name="email"></div>
    <div style="grid-column:1 / -1"><label>آدرس کامل</label><textarea class="input" name="address" required></textarea></div>
    <div style="grid-column:1 / -1"><div id="map" class="map"></div></div>
    <input type="hidden" name="lat" id="lat">
    <input type="hidden" name="lng" id="lng">
  </div>
  <p><button class="btn" type="submit">ثبت و انتقال به پرداخت</button></p>
</form>
<script>
  var map = L.map('map').setView([35.6892, 51.3890], 12);
  L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {attribution:'©OSM'}).addTo(map);
  var marker = L.marker([35.6892, 51.3890], {draggable:true}).addTo(map);
  document.getElementById('lat').value = 35.6892;
  document.getElementById('lng').value = 51.3890;
  marker.on('dragend', function(e){
    var ll = marker.getLatLng();
    document.getElementById('lat').value = ll.lat.toFixed(6);
    document.getElementById('lng').value = ll.lng.toFixed(6);
  });
  map.on('click', function(e){
    marker.setLatLng(e.latlng);
    document.getElementById('lat').value = e.latlng.lat.toFixed(6);
    document.getElementById('lng').value = e.latlng.lng.toFixed(6);
  });
</script>
